<?php
/**
 * Plugin Name: SIHA WooCommerce Integration
 * Plugin URI: https://siha.com/plugins/woocommerce
 * Description: Seamlessly integrate your WooCommerce store with SIHA (Smart Inventory & Handling Automation) for inventory and order management.
 * Version: 1.0.0
 * Author: SIHA Team
 * Author URI: https://siha.com
 * Text Domain: siha-woocommerce
 * Domain Path: /languages
 * Requires at least: 5.6
 * Requires PHP: 7.4
 * WC requires at least: 5.0
 * WC tested up to: 8.0
 *
 * @package SIHA_WooCommerce
 */

defined( 'ABSPATH' ) || exit;

// Define plugin constants
if ( ! defined( 'SIHA_WC_VERSION' ) ) {
    define( 'SIHA_WC_VERSION', '1.0.0' );
}

if ( ! defined( 'SIHA_WC_PLUGIN_FILE' ) ) {
    define( 'SIHA_WC_PLUGIN_FILE', __FILE__ );
}

if ( ! defined( 'SIHA_WC_PLUGIN_DIR' ) ) {
    define( 'SIHA_WC_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
}

if ( ! defined( 'SIHA_WC_PLUGIN_URL' ) ) {
    define( 'SIHA_WC_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
}

// Check if WooCommerce is active
if ( ! in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ), true ) ) {
    add_action( 'admin_notices', 'siha_wc_woocommerce_missing_notice' );
    return;
}

/**
 * WooCommerce fallback notice.
 */
function siha_wc_woocommerce_missing_notice() {
    /* translators: 1. URL link. */
    echo '<div class="error"><p><strong>' . sprintf( esc_html__( 'SIHA WooCommerce requires WooCommerce to be installed and active. You can download %s here.', 'siha-woocommerce' ), '<a href="https://woocommerce.com/" target="_blank">WooCommerce</a>' ) . '</strong></p></div>';
}

// Include the main plugin class
if ( ! class_exists( 'SIHA_WooCommerce' ) ) {
    include_once dirname( __FILE__ ) . '/includes/class-siha-woocommerce.php';
}

/**
 * Returns the main instance of SIHA_WooCommerce.
 *
 * @return SIHA_WooCommerce
 */
function siha_woocommerce() {
    return SIHA_WooCommerce::instance();
}

// Initialize the plugin
add_action( 'plugins_loaded', 'siha_woocommerce' );

// Activation and deactivation hooks
register_activation_hook( __FILE__, array( 'SIHA_WooCommerce', 'activate' ) );
register_deactivation_hook( __FILE__, array( 'SIHA_WooCommerce', 'deactivate' ) );
