# SIHA WooCommerce Integration

A WordPress plugin that integrates WooCommerce with the SIHA (Smart Inventory & Handling Automation) platform, enabling seamless product and order synchronization between your WooCommerce store and SIHA.

## Features

- **Product Synchronization**: Automatically sync products between WooCommerce and SIHA
- **Order Management**: Sync orders from WooCommerce to SIHA in real-time
- **Inventory Management**: Keep inventory levels in sync between platforms
- **User-Friendly Interface**: Easy-to-use settings page in the WordPress admin
- **Bulk Actions**: Sync multiple products or orders at once
- **Logging**: Detailed logging for debugging and troubleshooting

## Requirements

- WordPress 5.0 or later
- WooCommerce 4.0 or later
- PHP 7.4 or later
- cURL extension enabled

## Installation

1. Upload the `siha-woocommerce` folder to the `/wp-content/plugins/` directory
2. Activate the plugin through the 'Plugins' menu in WordPress
3. Go to WooCommerce > Settings > Products > SIHA Integration
4. Enter your SIHA API credentials and configure the plugin settings

## Configuration

### API Settings

1. **API Key**: Your SIHA API key (get this from your SIHA account)
2. **Enable Debug Mode**: Enable detailed logging for debugging purposes

### Synchronization Settings

1. **Auto Sync Products**: Enable/disable automatic product synchronization
2. **Auto Sync Orders**: Enable/disable automatic order synchronization
3. **Sync Frequency**: How often to sync data (hourly, twice daily, daily)

## Usage

### Manual Synchronization

You can manually sync products and orders from the SIHA settings page or using bulk actions in the WordPress admin.

### Shortcodes

- `[siha_products]`: Display a list of products synced with SIHA
- `[siha_orders]`: Display recent orders synced with SIHA

## Hooks and Filters

The plugin provides several hooks and filters for developers to extend its functionality:

### Actions

- `siha_before_product_sync`: Fires before a product is synced
- `siha_after_product_sync`: Fires after a product is synced
- `siha_before_order_sync`: Fires before an order is synced
- `siha_after_order_sync`: Fires after an order is synced

### Filters

- `siha_product_data`: Filter product data before syncing to SIHA
- `siha_order_data`: Filter order data before syncing to SIHA
- `siha_api_url`: Filter the SIHA API URL

## Support

For support, please contact [support@siha.com](mailto:support@siha.com) or visit our [help center](https://help.siha.com).

## Changelog

### 1.0.0
- Initial release

## License

GPL v2 or later

## Credits

Developed by the SIHA team.
